﻿using System;

namespace ThreeDedicatedCatchStatements
{
    class Tester
    {

        public void Run()
        {
            try
            {
                double a = 5;
                double b = 0;
                Console.WriteLine("Dzielenie {0} przez {1}...", a, b);
                Console.WriteLine("{0} / {1} = {2}", a, b, DoDivide(a, b));
            }
            // na początek najbardziej charakterystyczny wyjątek
            catch (DivideByZeroException)
            {
                Console.WriteLine("Przechwycono wyjątek DivideByZeroException!");
            }

            catch (ArithmeticException)
            {
                Console.WriteLine("Przechwycono wyjątek ArithmeticException!");
            }
            // na koniec ogólny wyjątek
            catch
            {
                Console.WriteLine("Przechwycono nieznany wyjątek");
            }
        }
        // wykonaj dzielenie, jeśli jest dopuszczalne
        public double DoDivide(double a, double b)
        {
            if (b == 0)
                throw new DivideByZeroException();
            if (a == 0)
                throw new ArithmeticException();
            return a / b;
        }

        static void Main()
        {
            Console.WriteLine("Wejście w Main()...");
            Tester t = new Tester();
            t.Run();
            Console.WriteLine("Wyjście z Main()...");
        }
    }
}